import os
import glob

# ユーザーからフォルダ名を入力してもらう
folder_name = input("フォルダ名を入力してください：")

# 対象となるディレクトリのパス
dir_path = "D:\\LoRA_make\\input_img\\" + folder_name

# ディレクトリ内のファイルのリスト
files = glob.glob(dir_path + "/*")

# 0埋めする桁数
digits = len(str(len(files)))

# ファイル名を変更する
for i, file in enumerate(files, start=1):
    # 元のファイルの拡張子を取得する 
    ext = os.path.splitext(file)[1] 
    # 新しいファイル名を作成する 
    new_name = str(i).zfill(digits) + ext 
    # ファイル名が既に存在する場合は、末尾にアンダースコアを追加する 
    while os.path.exists(os.path.join(dir_path, new_name)): 
        new_name = new_name + "_" 
    # ファイル名を変更する 
    os.rename(file, os.path.join(dir_path, new_name))
    # アンダースコアで終わる場合は、それを削除する
    if new_name.endswith("_"):
        new_name = new_name[:-1]
        os.rename(os.path.join(dir_path, new_name + "_"), os.path.join(dir_path, new_name))
