﻿# 必要なライブラリのインポート
import cv2
import os
import imgaug.augmenters as iaa

# 入力画像の保存先パスを設定（例：input_imagesフォルダ）
input_path = "D:\\LoRA_make\\input_padding_images\\"
# 出力画像の保存先パスを設定（例：output_imagesフォルダ）
output_path = "D:\\LoRA_make\\output_padding_images\\"
# 水増しする画像の枚数を実行時に入力
num_aug = int(input("水増しする画像の枚数を入力してください："))

# 画像処理手法とパラメータの設定（LoRA作成の教育用画像データに最適な加工）
augmenter = iaa.Sequential([
    iaa.Fliplr(0.5), # 左右反転（確率0.5）
    iaa.Affine( # アフィン変換
        scale={"x": (1.0, 1.1), "y": (1.0, 1.1)}, # スケーリング（x,y方向は0.9から1.1倍までランダム）
        translate_percent={"x": (-0.2, 0.2), "y": (-0.2, 0.2)}, # 平行移動（x,y方向は-20%から20%までランダム）
        rotate=(-15, 15), # 回転（-15度から15度までランダム）
        shear=(-3, 3) # シアー変換（-6度から6度までランダム）
    ),
    iaa.AddToHueAndSaturation((-20, 20)), # 色相と彩度にランダムに値を加える（-20から20まで）
    iaa.GammaContrast((0.5, 2.0)), # ガンマ補正（0.5から2.0までランダム）
])

# 入力画像のファイル名のリストを取得
input_files = os.listdir(input_path)
# 入力画像のファイル名ごとに処理を繰り返す
for input_file in input_files:
    # 入力画像のファイル名から拡張子を取得
    ext = os.path.splitext(input_file)[1]
    # 拡張子がjpgまたはpngの場合に処理を行う
    if ext == ".jpg" or ext == ".png":
        # 入力画像を読み込む
        image = cv2.imread(os.path.join(input_path, input_file))
        # 水増しする画像の枚数だけ処理を繰り返す
        for i in range(num_aug):
            # 画像に処理を適用
            augmented_image = augmenter(image=image)
            # 出力画像のファイル名を生成（元のファイル名に連番を付加）
            output_file = input_file.replace(ext, f"_{i+1}{ext}")
            # 出力画像を保存
            cv2.imwrite(os.path.join(output_path, output_file), augmented_image)

