# フォルダに存在する*.txtの内容を集積して１つのファイルにする
# 重複する単語は一つにします
# 対象となるtxtデータのフォルダの位置は自由に設定できるものとします

import glob # ファイル名を取得するためのモジュール
import os # ファイルパスを操作するためのモジュール

# 定数としてフォルダのベースパスを設定
BASE_FOLDER = "D:\\LoRA_make\\input_img\\"

folder = BASE_FOLDER 
folder_name = input("Enter the folder name: ") 

# フォルダ内の*.txtファイルのリストを取得します
file_list = glob.glob(os.path.join(folder, folder_name, "*.txt"))

# 結果を格納するための空のセットを作成します
result = set()

# ファイルリストを順に処理します
for file in file_list:
    # ファイルを開いて内容を読み込みます
    with open(file, "r") as f:
        content = f.read()
    # 読み込んだ内容をカンマで分割して単語のリストにします
    # その際に空白文字を除去します
    words = [word.strip() for word in content.split(",")]
    # 単語のリストをセットに変換して重複を除きます
    words = set(words)
    # 結果のセットに単語のリストを追加します
    result.update(words)

# 結果のセットをカンマで連結して文字列にします
result = ",".join(result)

# 結果を実行ファイルと同じ場所にresult.txtとして出力します
with open("all_words.txt", "w") as f:
    f.write(result)
