import os

# 定数としてフォルダのベースパスを設定
BASE_FOLDER = "D:\\LoRA_make\\input_img\\"

def load_words_from_file(filename):
    with open(filename, 'r') as file:
        words = file.read().split(',')
    return [word.strip() for word in words]

def remove_words_from_file(filename, words_to_remove):
    with open(filename, 'r') as file:
        lines = file.readlines()

    with open(filename, 'w') as file:
        for line in lines:
            cleaned_line = ', '.join(
                word.strip() for word in line.split(',') if word.strip() not in words_to_remove
            )
            if cleaned_line:
                file.write(cleaned_line + '\n')

def process_folder(folder_path, delete_words):
    for file in os.listdir(folder_path):
        if file.endswith(".txt"):
            file_path = os.path.join(folder_path, file)
            remove_words_from_file(file_path, delete_words)
            print(f"Processed: {file_path}")

if __name__ == "__main__":
    folder_name = input("Enter the folder name: ")
    folder_path = os.path.join(BASE_FOLDER, folder_name)
    
    if os.path.exists(folder_path):
        delete_words = load_words_from_file("delete_words.txt")
        process_folder(folder_path, delete_words)
        print("Words removed from all txt files in the specified folder.")
    else:
        print("Specified folder does not exist.")
